﻿//////////////////////////////////////////////
// ObjDecodeOptions.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/String.h>

/// Enums ------------------------------------

namespace nkGraphics
{
	enum class OBJ_SPACE
	{
		UP_Y_FRONT_Z = 0,
		UP_Y_FRONT_MINUS_Z
	} ;
}

/// Class ------------------------------------

namespace nkGraphics
{
	struct ObjDecodeOptions final
	{
		// Attributes
		// Mtl info
		nkMemory::String _mtlFolderAbsPath ;

		// Space the obj is coming from
		OBJ_SPACE _objSpace = OBJ_SPACE::UP_Y_FRONT_Z ;

		// Whether to invert UV's y
		bool _invertUvY = false ;
		// Whether to correct winding or not
		bool _invertWindingOrder = false ;
		// Whether we should pre-load images
		bool _loadImages = false ;
	} ;
}